in vec2 texCoord;
uniform sampler2D colorMap;
uniform vec4 glColor;
uniform float testvalue;
uniform float testvalue2;
uniform float blurradius;
uniform float intensity;

void main (void)
{
	float powf=2.0;
	const float xp=1.0/1920.0;
	const float yp=1.0/1080.0;
	float spread=2.0*blurradius;
	const float cutoff=1.0;//testvalue;
	vec4 col=texture2D(colorMap, texCoord);
	vec4 res=col;
	for (int i=-2;i<2;i+=1){
		for (int j=-2;j<2;j+=1){
			//vec4 curr=texture2D(colorMap, clamp(texCoord+vec2(xp*(float)i,yp*(float)j)*spread,0.0,0.1-1.0/1080.0));
			vec2 currtexcoo=texCoord+vec2(xp*(float)i,yp*(float)j)*spread;
			currtexcoo.x=clamp(currtexcoo.x,0,1.0-1.0/1920.0f);
			currtexcoo.y=clamp(currtexcoo.y,0,1.0-1.0/1080.0f);
			vec4 curr=texture2D(colorMap, currtexcoo);
			curr.r=pow(clamp(curr.r/cutoff,0,1),powf);
			curr.g=pow(clamp(curr.g/cutoff,0,1),powf);
			curr.b=pow(clamp(curr.b/cutoff,0,1),powf);
			res+=curr;
		}
	}
	//res/=26.0*4.0*3.5*0.14*4.0 *2.4;
	res/=5.0*4.0*3.5*0.14*4.0 *2.4;
	col+=res;
	//col.r=1.0;
	vec4 col2=texture2D(colorMap, texCoord);
	col=mix(col,col2,intensity);

	vec4 c;
	float t=5.6*0.38*0.26;
	float t2=1.096;
	const float fill = 0.9;
	if (col.r>0.7/t*t2) c=vec4(fill,fill,fill,1.0);
	const float outline = 0.4;
	if (col.r<=0.7/t*t2 && col.r>=0.1/t) c=vec4(outline,outline,outline,1.0);
	//if (col.r<=0.7/t && col.r>=0.2/t) c=vec4(1.0,0,0,1.0);
	if (col.r<0.1/t) c=vec4(0,0,0,0);

	gl_FragColor = c;
}
